<?php $__env->startSection('title'); ?>
    <?php echo e($parent->name ?? $category->path ?? $category->name ?? 'Toate Articolele'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('actions'); ?>
    
    
    
    
    <?php if(!$category || $category && $category->can_create_articles): ?>
        <a href="<?php echo e(route('admin.articles.create', ['category_id' => $category->id ?? '', 'parent_id' => request('parent_id') ?? ''])); ?>"
           class="btn btn-primary m-md">
            <i class="fa fa-plus-circle"></i>
            adauga
        </a>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="ibox-content m-b-sm border-bottom filters-n-stuff anim">

        <div class="row">
            <div class="col-sm-12 col-md-6 col-lg-7">
                <form action="<?php echo e(route('admin.articles.index')); ?>" method="GET">
                    <div class="form-group">
                        <label class="control-label">Cautare in articole. Apasati enter</label>
                        <input type="text" name="q" value="" placeholder="Ce cautati?" class="form-control">
                        <?php $__currentLoopData = request()->except(['page', 'q']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </form>
            </div>


            <?php if(auth()->user()->isSuperAdmin() || request('parent_id')): ?>
                <div class="col-sm-12 col-md-6 col-lg-5">
                    <form action="<?php echo e(route('admin.articles.index')); ?>" class="" method="GET">
                        <div class="form-group">
                            <label class="control-label <?php echo e(request('category_id') ? 'text-primary'  : ''); ?>" for="status">Categorie</label>
                            <select name="category_id" class="form-control" onchange="this.form.submit()">

                                <?php if(request('root_id') != request('category_id')): ?>
                                    <option value="">Toate din sectiune</option>
                                <?php endif; ?>

                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($category->can_have_children): ?>
                                        <optgroup label="<?php echo e($category->name); ?>">
                                            <?php $__currentLoopData = $category->subcats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($subcategory->id); ?>"
                                                        <?php echo e($subcategory->id == request('category_id') ? 'selected=selected' : ''); ?> >
                                                    <?php echo e($subcategory->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </optgroup>
                                    <?php else: ?>
                                        <option value="<?php echo e($category->id); ?>"
                                                <?php echo e($category->id == request('category_id') ? 'selected=selected' : ''); ?> >
                                            <?php echo e($category->name); ?>

                                        </option>
                                    <?php endif; ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__currentLoopData = request()->except(['page', 'category_id']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </form>
                </div>
            <?php endif; ?>

        </div>


    </div>


    <div class="alert alert-light no-margins">
        <div class="row align-items-center">
            <div class="col-md my-1 my-md-0">
                <?php echo e($articles->total()); ?> articole
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('access')): ?>
                    <?php if(count(request()->except('page'))): ?>
                        <a href="<?php echo e(route('admin.articles.index')); ?>" class="btn-white btn-sm m-l">
                            anuleaza toate filtrele
                        </a>
                    <?php endif; ?>
                <?php else: ?>
                    <?php if(count(request()->except('category_id', 'parent_id'))): ?>
                        <a href="<?php echo e(route('admin.articles.index',  request()->only(['parent_id', 'category_id']))); ?>"
                           class="btn-white btn-sm m-l">
                            anuleaza toate filtrele
                        </a>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php if(request('q')): ?>
        <p class="p-xs">
            Se cauta dupa
            <b>
                <?php echo e(request('q')); ?>

            </b>
        </p>
    <?php endif; ?>

    <style>
        table td {
            vertical-align: middle !important;
        }
    </style>
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-content table-responsive">
                    <table class="table table-stripped toggle-arrow-tiny table-hover table-action " data-page-size="50"
                           data-filtering="true">
                        <thead>
                        <tr>
                            <th data-sort-ignore="true" style="width: 1%" class="text-nowrap">
                                #
                                <a href="<?php echo e(route('admin.articles.index', ['order_by' =>  'id', 'order_direction' => 'asc'])); ?>"><i
                                            class="fa fa-caret-up"></i></a>
                                <a href="<?php echo e(route('admin.articles.index', ['order_by' =>  'id', 'order_direction' => 'desc'])); ?>"><i
                                            class="fa fa-caret-down"></i></a>
                            </th>


                            <th data-toggle="true">Titlu</th>
                            <th data-toggle="true">Categorie</th>
                            
                            
                            
                            
                            
                            

                            <th class="text-nowrap">Stare
                                <a href="<?php echo e(route('admin.articles.index', ['order_by' =>  'status', 'order_direction' => 'asc'])); ?>"><i
                                            class="fa fa-caret-up"></i></a>
                                <a href="<?php echo e(route('admin.articles.index', ['order_by' =>  'status', 'order_direction' => 'desc'])); ?>"><i
                                            class="fa fa-caret-down"></i></a>
                            </th>
                            <th class="text-right" data-sort-ignore="true">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('admin.articles.edit', $article)); ?>">
                                        <img src="<?php echo e($article->getThumbUrl()); ?>"
                                             style="width: 64px; height:64px; object-fit: cover"/>
                                    </a>
                                </td>

                                <td>
                                    <a href="<?php echo e(route('admin.articles.edit', $article)); ?>"><?php echo e($article->title); ?></a>
                                    <p>
                                        <small>
                                            Scris de <?php echo e($article->user ? $article->user->getName() : 'sters'); ?>

                                            la <?php echo e($article->created_at); ?>

                                        </small>
                                    </p>
                                </td>

                                <td>
                                    <?php echo e($article->category->path); ?>

                                </td>

                                
                                
                                
                                
                                

                                <td>
                                    <span class="badge badge-<?php echo e($article->status_class); ?>">
                                        <?php echo e($article->status); ?>

                                    </span>
                                </td>

                                <td class="text-right">
                                    <div class="btn-group-or-not text-nowrap">
                                        <?php if($article->isPending()): ?>
                                            <form action="<?php echo e(route('admin.articles.update', $article)); ?>" class="inline"
                                                  method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <input type="hidden" name="status"
                                                       value="active"/>
                                                <input type="submit"
                                                       value="aproba"
                                                       class="btn btn-xs btn-warning"/>
                                            </form>
                                        <?php endif; ?>

                                        <a href="<?php echo e($article->getUrl()); ?>" class="btn-white btn btn-xs"
                                           target="_blank">vezi</a>
                                        <a href="<?php echo e(route('admin.articles.edit', $article)); ?>"
                                           class="btn-success btn btn-xs btn-edit">edit</a>

                                        <?php if($article->category->can_create_articles): ?>
                                            <form action="<?php echo e(route('admin.articles.destroy', $article)); ?>" class="inline"
                                                  method="POST">
                                                <?php echo e(method_field('DELETE' )); ?>

                                                <?php echo e(csrf_field()); ?>

                                                <button type="submit" class="btn btn-xs btn-delete btn-danger"
                                                        onclick="return confirm('sigur stergeti?')">
                                                    sterge
                                                </button>

                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="6">
                                <ul class="pagination pull-right"></ul>
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                    <?php echo e($articles->links('vendor.pagination.bootstrap')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/superch1/public_html/resources/views/admin/article/index.blade.php ENDPATH**/ ?>