<?php //6a0af1353e2acbd7757f236898234776
/** @noinspection all */

namespace App\Model {

    use App\Model\Article\ArticleCategory;
    use App\Model\Article\ArticleComment;
    use App\Model\Article\ArticlePhoto;
    use App\Model\Brand\BrandPhoto;
    use App\Model\Category\CategoryAttribute;
    use App\Model\Gallery\GalleryPhoto;
    use App\Model\Order\OrderProduct;
    use App\Model\Order\OrderVendor;
    use App\Model\Product\ProductAttribute;
    use App\Model\Product\ProductDocument;
    use App\Model\Product\ProductOffer;
    use App\Model\Product\ProductPhoto;
    use App\Model\User\UserSetting;
    use Icetech\Payment\Models\Transaction;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleCategory_QB;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleComment_C;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleComment_QB;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticlePhoto_C;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticlePhoto_QB;
    use LaravelIdea\Helper\App\Model\Brand\_IH_BrandPhoto_QB;
    use LaravelIdea\Helper\App\Model\Category\_IH_CategoryAttribute_C;
    use LaravelIdea\Helper\App\Model\Category\_IH_CategoryAttribute_QB;
    use LaravelIdea\Helper\App\Model\Gallery\_IH_GalleryPhoto_C;
    use LaravelIdea\Helper\App\Model\Gallery\_IH_GalleryPhoto_QB;
    use LaravelIdea\Helper\App\Model\Order\_IH_OrderProduct_C;
    use LaravelIdea\Helper\App\Model\Order\_IH_OrderProduct_QB;
    use LaravelIdea\Helper\App\Model\Order\_IH_OrderVendor_C;
    use LaravelIdea\Helper\App\Model\Order\_IH_OrderVendor_QB;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductAttribute_C;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductAttribute_QB;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductDocument_C;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductDocument_QB;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductOffer_C;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductOffer_QB;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductPhoto_C;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductPhoto_QB;
    use LaravelIdea\Helper\App\Model\User\_IH_UserSetting_QB;
    use LaravelIdea\Helper\App\Model\_IH_Ad_C;
    use LaravelIdea\Helper\App\Model\_IH_Ad_QB;
    use LaravelIdea\Helper\App\Model\_IH_Article_C;
    use LaravelIdea\Helper\App\Model\_IH_Article_QB;
    use LaravelIdea\Helper\App\Model\_IH_Attribute_C;
    use LaravelIdea\Helper\App\Model\_IH_Attribute_QB;
    use LaravelIdea\Helper\App\Model\_IH_Brand_C;
    use LaravelIdea\Helper\App\Model\_IH_Brand_QB;
    use LaravelIdea\Helper\App\Model\_IH_Category_C;
    use LaravelIdea\Helper\App\Model\_IH_Category_QB;
    use LaravelIdea\Helper\App\Model\_IH_Contact_C;
    use LaravelIdea\Helper\App\Model\_IH_Contact_QB;
    use LaravelIdea\Helper\App\Model\_IH_Country_C;
    use LaravelIdea\Helper\App\Model\_IH_Country_QB;
    use LaravelIdea\Helper\App\Model\_IH_County_C;
    use LaravelIdea\Helper\App\Model\_IH_County_QB;
    use LaravelIdea\Helper\App\Model\_IH_Cover_C;
    use LaravelIdea\Helper\App\Model\_IH_Cover_QB;
    use LaravelIdea\Helper\App\Model\_IH_Gallery_C;
    use LaravelIdea\Helper\App\Model\_IH_Gallery_QB;
    use LaravelIdea\Helper\App\Model\_IH_MailingList_C;
    use LaravelIdea\Helper\App\Model\_IH_MailingList_QB;
    use LaravelIdea\Helper\App\Model\_IH_Order_C;
    use LaravelIdea\Helper\App\Model\_IH_Order_QB;
    use LaravelIdea\Helper\App\Model\_IH_Product_C;
    use LaravelIdea\Helper\App\Model\_IH_Product_QB;
    use LaravelIdea\Helper\App\Model\_IH_Review_C;
    use LaravelIdea\Helper\App\Model\_IH_Review_QB;
    use LaravelIdea\Helper\App\Model\_IH_Text_C;
    use LaravelIdea\Helper\App\Model\_IH_Text_QB;
    use LaravelIdea\Helper\App\Model\_IH_User_C;
    use LaravelIdea\Helper\App\Model\_IH_User_QB;
    use LaravelIdea\Helper\App\Model\_IH_Vendor_C;
    use LaravelIdea\Helper\App\Model\_IH_Vendor_QB;
    use LaravelIdea\Helper\App\Model\_IH_Video_C;
    use LaravelIdea\Helper\App\Model\_IH_Video_QB;
    use LaravelIdea\Helper\App\Model\_IH_Voucher_C;
    use LaravelIdea\Helper\App\Model\_IH_Voucher_QB;
    use LaravelIdea\Helper\Icetech\Payment\Models\_IH_Transaction_C;
    use LaravelIdea\Helper\Icetech\Payment\Models\_IH_Transaction_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_C;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $photo
     * @property string|null $url
     * @property bool $show_on_mobile
     * @property string $visibility
     * @property int $priority
     * @property bool $is_featured
     * @property bool $is_active
     * @property int $hits
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Ad_QB onWriteConnection()
     * @method _IH_Ad_QB newQuery()
     * @method static _IH_Ad_QB on(null|string $connection = null)
     * @method static _IH_Ad_QB query()
     * @method static _IH_Ad_QB with(array|string $relations)
     * @method _IH_Ad_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Ad_C|Ad[] all()
     * @mixin _IH_Ad_QB
     */
    class Ad extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $slug
     * @property int $category_id
     * @property string|null $title
     * @property string|null $body
     * @property bool $is_featured
     * @property bool $has_slug_locked
     * @property string $status
     * @property int|null $photo_id
     * @property string|null $search
     * @property Carbon|null $published_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $description attribute
     * @property-read $name attribute
     * @property-read $path attribute
     * @property-read string|void $status_class attribute
     * @property-read $url attribute
     * @property-read $value attribute
     * @property ArticleCategory $category
     * @method BelongsTo|_IH_ArticleCategory_QB category()
     * @property _IH_ArticleComment_C|ArticleComment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_ArticleComment_QB comments()
     * @property ArticlePhoto|null $photo
     * @method BelongsTo|_IH_ArticlePhoto_QB photo()
     * @property _IH_ArticlePhoto_C|ArticlePhoto[] $photos
     * @property-read int $photos_count
     * @method HasMany|_IH_ArticlePhoto_QB photos()
     * @property _IH_ArticleComment_C|ArticleComment[] $recentComments
     * @property-read int $recent_comments_count
     * @method HasMany|_IH_ArticleComment_QB recentComments()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Article_QB onWriteConnection()
     * @method _IH_Article_QB newQuery()
     * @method static _IH_Article_QB on(null|string $connection = null)
     * @method static _IH_Article_QB query()
     * @method static _IH_Article_QB with(array|string $relations)
     * @method _IH_Article_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Article_C|Article[] all()
     * @ownLinks user_id,\App\Model\Vendor,id|category_id,\App\Model\Category,id
     * @foreignLinks id,\App\Model\Article\ArticlePhoto,article_id
     * @mixin _IH_Article_QB
     */
    class Article extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string $slug
     * @property bool $is_range
     * @property int $priority
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $body attribute
     * @property-read $description attribute
     * @property-read $final_value attribute
     * @property-read $path attribute
     * @property-read $title attribute
     * @property-read $url attribute
     * @property-read $value attribute
     * @property _IH_ProductAttribute_C|ProductAttribute[] $productAttributes
     * @property-read int $product_attributes_count
     * @method HasMany|_IH_ProductAttribute_QB productAttributes()
     * @method static _IH_Attribute_QB onWriteConnection()
     * @method _IH_Attribute_QB newQuery()
     * @method static _IH_Attribute_QB on(null|string $connection = null)
     * @method static _IH_Attribute_QB query()
     * @method static _IH_Attribute_QB with(array|string $relations)
     * @method _IH_Attribute_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Attribute_C|Attribute[] all()
     * @foreignLinks id,\App\Model\Category\CategoryAttribute,attribute_id|id,\App\Model\Product\ProductAttribute,attribute_id
     * @mixin _IH_Attribute_QB
     */
    class Attribute extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string|null $description
     * @property string|null $url
     * @property string|null $logo
     * @property bool $is_featured
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $body attribute
     * @property-read $path attribute
     * @property-read $title attribute
     * @property-read $value attribute
     * @property BrandPhoto $photo
     * @method BelongsTo|_IH_BrandPhoto_QB photo()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_Product_QB products()
     * @method static _IH_Brand_QB onWriteConnection()
     * @method _IH_Brand_QB newQuery()
     * @method static _IH_Brand_QB on(null|string $connection = null)
     * @method static _IH_Brand_QB query()
     * @method static _IH_Brand_QB with(array|string $relations)
     * @method _IH_Brand_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Brand_C|Brand[] all()
     * @foreignLinks id,\App\Model\Product,brand_id
     * @mixin _IH_Brand_QB
     */
    class Brand extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $short_name
     * @property string $slug
     * @property int $parent_id
     * @property bool $has_children
     * @property bool $is_visible_in_menu
     * @property bool $is_featured
     * @property bool $is_active
     * @property string|null $photo
     * @property string|null $path
     * @property int $priority
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $body attribute
     * @property-read $description attribute
     * @property-read $first_product attribute
     * @property-read $title attribute
     * @property-read $url attribute
     * @property-read $value attribute
     * @property _IH_CategoryAttribute_C|CategoryAttribute[] $attributes
     * @property-read int $attributes_count
     * @method HasMany|_IH_CategoryAttribute_QB attributes()
     * @property _IH_Attribute_C|Attribute[] $attributesPivot
     * @property-read int $attributes_pivot_count
     * @method BelongsToMany|_IH_Attribute_QB attributesPivot()
     * @property _IH_Category_C|Category[] $children
     * @property-read int $children_count
     * @method HasMany|_IH_Category_QB children()
     * @property _IH_CategoryAttribute_C|CategoryAttribute[] $filters
     * @property-read int $filters_count
     * @method HasMany|_IH_CategoryAttribute_QB filters()
     * @property Category $parentCat
     * @method BelongsTo|_IH_Category_QB parentCat()
     * @property _IH_Product_C|Product[] $product
     * @property-read int $product_count
     * @method BelongsToMany|_IH_Product_QB product()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method BelongsToMany|_IH_Product_QB products()
     * @property _IH_Product_C|Product[] $products_active
     * @property-read int $products_active_count
     * @method BelongsToMany|_IH_Product_QB products_active()
     * @property _IH_Product_C|Product[] $tiedActiveProducts
     * @property-read int $tied_active_products_count
     * @method HasMany|_IH_Product_QB tiedActiveProducts()
     * @property _IH_Product_C|Product[] $tiedProducts
     * @property-read int $tied_products_count
     * @method HasMany|_IH_Product_QB tiedProducts()
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all()
     * @foreignLinks id,\App\Model\Category\CategoryAttribute,category_id|id,\App\Model\Product,category_id|id,\App\Model\Gallery,category_id|id,\App\Model\Article,category_id
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string $type
     * @property string|null $company_name
     * @property string|null $company_reg
     * @property string|null $company_cui
     * @property string|null $bankaccount
     * @property string|null $cnp
     * @property string|null $firstname
     * @property string|null $lastname
     * @property string|null $email
     * @property string|null $phone
     * @property string|null $address
     * @property string|null $city
     * @property string|null $postalcode
     * @property int $country_id
     * @property int $county_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property County $county
     * @method BelongsTo|_IH_County_QB county()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Contact_QB onWriteConnection()
     * @method _IH_Contact_QB newQuery()
     * @method static _IH_Contact_QB on(null|string $connection = null)
     * @method static _IH_Contact_QB query()
     * @method static _IH_Contact_QB with(array|string $relations)
     * @method _IH_Contact_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Contact_C|Contact[] all()
     * @ownLinks user_id,\App\Model\Vendor,id
     * @mixin _IH_Contact_QB
     */
    class Contact extends Model {}
    
    /**
     * @method static _IH_Country_QB onWriteConnection()
     * @method _IH_Country_QB newQuery()
     * @method static _IH_Country_QB on(null|string $connection = null)
     * @method static _IH_Country_QB query()
     * @method static _IH_Country_QB with(array|string $relations)
     * @method _IH_Country_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Country_C|Country[] all()
     * @mixin _IH_Country_QB
     */
    class Country extends Model {}
    
    /**
     * @method static _IH_County_QB onWriteConnection()
     * @method _IH_County_QB newQuery()
     * @method static _IH_County_QB on(null|string $connection = null)
     * @method static _IH_County_QB query()
     * @method static _IH_County_QB with(array|string $relations)
     * @method _IH_County_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_County_C|County[] all()
     * @mixin _IH_County_QB
     */
    class County extends Model {}
    
    /**
     * @property int $id
     * @property string $slug
     * @property string $filename
     * @property string|null $product_filename
     * @property string|null $title
     * @property string|null $body
     * @property string|null $button_text
     * @property string|null $url
     * @property int $priority
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $description attribute
     * @property-read $name attribute
     * @property-read $path attribute
     * @property-read $value attribute
     * @method static _IH_Cover_QB onWriteConnection()
     * @method _IH_Cover_QB newQuery()
     * @method static _IH_Cover_QB on(null|string $connection = null)
     * @method static _IH_Cover_QB query()
     * @method static _IH_Cover_QB with(array|string $relations)
     * @method _IH_Cover_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Cover_C|Cover[] all()
     * @mixin _IH_Cover_QB
     */
    class Cover extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string $slug
     * @property int|null $category_id
     * @property string|null $description
     * @property string|null $url
     * @property bool $is_active
     * @property bool $is_featured
     * @property int|null $photo_id
     * @property string $status
     * @property int $priority
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $body attribute
     * @property-read $path attribute
     * @property-read string|void $status_class attribute
     * @property-read $title attribute
     * @property-read $value attribute
     * @property GalleryPhoto|null $photo
     * @method BelongsTo|_IH_GalleryPhoto_QB photo()
     * @property _IH_GalleryPhoto_C|GalleryPhoto[] $photos
     * @property-read int $photos_count
     * @method HasMany|_IH_GalleryPhoto_QB photos()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Gallery_QB onWriteConnection()
     * @method _IH_Gallery_QB newQuery()
     * @method static _IH_Gallery_QB on(null|string $connection = null)
     * @method static _IH_Gallery_QB query()
     * @method static _IH_Gallery_QB with(array|string $relations)
     * @method _IH_Gallery_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Gallery_C|Gallery[] all()
     * @ownLinks category_id,\App\Model\Category,id
     * @foreignLinks id,\App\Model\Gallery\GalleryPhoto,gallery_id
     * @mixin _IH_Gallery_QB
     */
    class Gallery extends Model {}
    
    /**
     * @property int $id
     * @property string $email
     * @property int|null $user_id
     * @property string $ip
     * @property string|null $user_agent
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_MailingList_QB onWriteConnection()
     * @method _IH_MailingList_QB newQuery()
     * @method static _IH_MailingList_QB on(null|string $connection = null)
     * @method static _IH_MailingList_QB query()
     * @method static _IH_MailingList_QB with(array|string $relations)
     * @method _IH_MailingList_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MailingList_C|MailingList[] all()
     * @ownLinks user_id,\App\Model\Vendor,id
     * @mixin _IH_MailingList_QB
     */
    class MailingList extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $code
     * @property int|null $billing_contact_id
     * @property int|null $delivery_contact_id
     * @property float $price
     * @property float $price_delivery
     * @property string $status
     * @property string $delivery_type
     * @property string $payment_type
     * @property bool $is_paid
     * @property int $product_count
     * @property int|null $voucher_id
     * @property string|null $voucher_code
     * @property float|null $voucher_discount
     * @property string|null $remarks
     * @property string|null $internal_remarks
     * @property string|null $ip
     * @property string|null $user_agent
     * @property array|null $billing_contact_data
     * @property array|null $delivery_contact_data
     * @property string|null $search
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $payment_mode
     * @property string|null $payment_status
     * @property int|null $payment_status_code
     * @property bool $mail_sent
     * @property-read Contact $billing_contact attribute
     * @property-read Contact $delivery_contact attribute
     * @property-read $status_class attribute
     * @property-read $status_detail attribute
     * @property Contact|null $billingContactFromRelation
     * @method BelongsTo|_IH_Contact_QB billingContactFromRelation()
     * @property Contact|null $deliveryContactFromRelation
     * @method BelongsTo|_IH_Contact_QB deliveryContactFromRelation()
     * @property _IH_OrderProduct_C|OrderProduct[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_OrderProduct_QB products()
     * @property Transaction $transaction
     * @method HasOne|_IH_Transaction_QB transaction()
     * @property _IH_Transaction_C|Transaction[] $transactions
     * @property-read int $transactions_count
     * @method HasMany|_IH_Transaction_QB transactions()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @property _IH_OrderVendor_C|OrderVendor[] $vendors
     * @property-read int $vendors_count
     * @method HasMany|_IH_OrderVendor_QB vendors()
     * @property Voucher|null $voucher
     * @method BelongsTo|_IH_Voucher_QB voucher()
     * @method static _IH_Order_QB onWriteConnection()
     * @method _IH_Order_QB newQuery()
     * @method static _IH_Order_QB on(null|string $connection = null)
     * @method static _IH_Order_QB query()
     * @method static _IH_Order_QB with(array|string $relations)
     * @method _IH_Order_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Order_C|Order[] all()
     * @ownLinks user_id,\App\Model\Vendor,id|voucher_id,\App\Model\Voucher,id
     * @foreignLinks id,\App\Model\Order\OrderVendor,order_id|id,\App\Model\Order\OrderProduct,order_id|id,\Icetech\Payment\Models\Transaction,order_id
     * @mixin _IH_Order_QB
     */
    class Order extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string $slug
     * @property string|null $code
     * @property int $priority
     * @property int|null $category_id
     * @property int|null $photo_id
     * @property int|null $brand_id
     * @property string|null $description
     * @property bool $is_featured
     * @property int|null $vendor_id
     * @property int|null $offer_id
     * @property float|null $price
     * @property float|null $price_promo
     * @property int $stock
     * @property int $rating_count
     * @property float $rating_avg
     * @property string|null $search
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $body attribute
     * @property-read $path attribute
     * @property-read $title attribute
     * @property-read $url attribute
     * @property-read bool $validate_stock attribute
     * @property-read $value attribute
     * @property _IH_ProductOffer_C|ProductOffer[] $activeOffers
     * @property-read int $active_offers_count
     * @method HasMany|_IH_ProductOffer_QB activeOffers()
     * @property _IH_Attribute_C|Attribute[] $attributes
     * @property-read int $attributes_count
     * @method BelongsToMany|_IH_Attribute_QB attributes()
     * @property _IH_ProductAttribute_C|ProductAttribute[] $attributesForDynamicFilters
     * @property-read int $attributes_for_dynamic_filters_count
     * @method HasMany|_IH_ProductAttribute_QB attributesForDynamicFilters()
     * @property _IH_Attribute_C|Attribute[] $attributesPivot
     * @property-read int $attributes_pivot_count
     * @method BelongsToMany|_IH_Attribute_QB attributesPivot()
     * @property Brand|null $brand
     * @method BelongsTo|_IH_Brand_QB brand()
     * @property _IH_Category_C|Category[] $categories
     * @property-read int $categories_count
     * @method BelongsToMany|_IH_Category_QB categories()
     * @property _IH_Category_C|Category[] $categoriesNoRoot
     * @property-read int $categories_no_root_count
     * @method BelongsToMany|_IH_Category_QB categoriesNoRoot()
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_Attribute_C|Attribute[] $characteristics
     * @property-read int $characteristics_count
     * @method BelongsToMany|_IH_Attribute_QB characteristics()
     * @property _IH_ProductDocument_C|ProductDocument[] $documents
     * @property-read int $documents_count
     * @method HasMany|_IH_ProductDocument_QB documents()
     * @property ProductOffer|null $offer
     * @method BelongsTo|_IH_ProductOffer_QB offer()
     * @property _IH_ProductOffer_C|ProductOffer[] $offers
     * @property-read int $offers_count
     * @method HasMany|_IH_ProductOffer_QB offers()
     * @property ProductPhoto|null $photo
     * @method BelongsTo|_IH_ProductPhoto_QB photo()
     * @property _IH_ProductPhoto_C|ProductPhoto[] $photos
     * @property-read int $photos_count
     * @method HasMany|_IH_ProductPhoto_QB photos()
     * @property _IH_Review_C|Review[] $reviews
     * @property-read int $reviews_count
     * @method HasMany|_IH_Review_QB reviews()
     * @property Vendor|null $vendor
     * @method BelongsTo|_IH_Vendor_QB vendor()
     * @method static _IH_Product_QB onWriteConnection()
     * @method _IH_Product_QB newQuery()
     * @method static _IH_Product_QB on(null|string $connection = null)
     * @method static _IH_Product_QB query()
     * @method static _IH_Product_QB with(array|string $relations)
     * @method _IH_Product_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_C|Product[] all()
     * @ownLinks category_id,\App\Model\Category,id|brand_id,\App\Model\Brand,id
     * @foreignLinks id,\App\Model\Product\ProductAttribute,product_id|id,\App\Model\Product\ProductOffer,product_id|id,\App\Model\Product\ProductPhoto,product_id|id,\App\Model\Review,product_id|id,\App\Model\Product\ProductDocument,product_id|id,\App\Model\Order\OrderProduct,product_id
     * @mixin _IH_Product_QB
     */
    class Product extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property int|null $user_id
     * @property bool $is_active
     * @property string|null $name
     * @property string|null $email
     * @property string $body
     * @property int $rating
     * @property string|null $ip
     * @property string|null $user_agent
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Review_QB onWriteConnection()
     * @method _IH_Review_QB newQuery()
     * @method static _IH_Review_QB on(null|string $connection = null)
     * @method static _IH_Review_QB query()
     * @method static _IH_Review_QB with(array|string $relations)
     * @method _IH_Review_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Review_C|Review[] all()
     * @ownLinks product_id,\App\Model\Product,id|user_id,\App\Model\Vendor,id
     * @mixin _IH_Review_QB
     */
    class Review extends Model {}
    
    /**
     * @property int $id
     * @property string|null $slug
     * @property bool $has_rich_editor
     * @property string|null $title
     * @property string|null $body
     * @property int $priority
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Text_QB onWriteConnection()
     * @method _IH_Text_QB newQuery()
     * @method static _IH_Text_QB on(null|string $connection = null)
     * @method static _IH_Text_QB query()
     * @method static _IH_Text_QB with(array|string $relations)
     * @method _IH_Text_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Text_C|Text[] all()
     * @mixin _IH_Text_QB
     */
    class Text extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $slug
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property int $is_admin
     * @property bool $is_active
     * @property bool $is_featured
     * @property string $type
     * @property int $rating_count
     * @property float $rating_avg
     * @property int $unread_message_count
     * @property int|null $facebook_id
     * @property array|null $facebook_data
     * @property string|null $ip
     * @property string|null $user_agent
     * @property string|null $search
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Contact $billingContact
     * @method HasOne|_IH_Contact_QB billingContact()
     * @property _IH_Contact_C|Contact[] $contacts
     * @property-read int $contacts_count
     * @method HasMany|_IH_Contact_QB contacts()
     * @property Contact $deliveryContact
     * @method HasOne|_IH_Contact_QB deliveryContact()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Order_C|Order[] $orders
     * @property-read int $orders_count
     * @method HasMany|_IH_Order_QB orders()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method BelongsToMany|_IH_Product_QB products()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property UserSetting $setting
     * @method HasOne|_IH_UserSetting_QB setting()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property _IH_OrderVendor_C|OrderVendor[] $vendorOrders
     * @property-read int $vendor_orders_count
     * @method HasMany|_IH_OrderVendor_QB vendorOrders()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @foreignLinks id,\App\Model\User\UserSetting,user_id|id,\App\Model\Review,user_id|id,\App\Model\Article,user_id|id,\App\Model\MailingList,user_id|id,\App\Model\Contact,user_id|id,\App\Model\Order,user_id
     * @mixin _IH_User_QB
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $slug
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property int $is_admin
     * @property bool $is_active
     * @property bool $is_featured
     * @property string $type
     * @property int $rating_count
     * @property float $rating_avg
     * @property int $unread_message_count
     * @property int|null $facebook_id
     * @property array|null $facebook_data
     * @property string|null $ip
     * @property string|null $user_agent
     * @property string|null $search
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Contact $billingContact
     * @method HasOne|_IH_Contact_QB billingContact()
     * @property _IH_Contact_C|Contact[] $contacts
     * @property-read int $contacts_count
     * @method HasMany|_IH_Contact_QB contacts()
     * @property Contact $deliveryContact
     * @method HasOne|_IH_Contact_QB deliveryContact()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Order_C|Order[] $orders
     * @property-read int $orders_count
     * @method HasMany|_IH_Order_QB orders()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method BelongsToMany|_IH_Product_QB products()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property UserSetting $setting
     * @method HasOne|_IH_UserSetting_QB setting()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property _IH_OrderVendor_C|OrderVendor[] $vendorOrders
     * @property-read int $vendor_orders_count
     * @method HasMany|_IH_OrderVendor_QB vendorOrders()
     * @method static _IH_Vendor_QB onWriteConnection()
     * @method _IH_Vendor_QB newQuery()
     * @method static _IH_Vendor_QB on(null|string $connection = null)
     * @method static _IH_Vendor_QB query()
     * @method static _IH_Vendor_QB with(array|string $relations)
     * @method _IH_Vendor_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Vendor_C|Vendor[] all()
     * @foreignLinks id,\App\Model\User\UserSetting,user_id|id,\App\Model\Review,user_id|id,\App\Model\Article,user_id|id,\App\Model\MailingList,user_id|id,\App\Model\Contact,user_id|id,\App\Model\Order,user_id
     * @mixin _IH_Vendor_QB
     */
    class Vendor extends Model {}
    
    /**
     * @property int $id
     * @property string $youtube_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Video_QB onWriteConnection()
     * @method _IH_Video_QB newQuery()
     * @method static _IH_Video_QB on(null|string $connection = null)
     * @method static _IH_Video_QB query()
     * @method static _IH_Video_QB with(array|string $relations)
     * @method _IH_Video_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Video_C|Video[] all()
     * @mixin _IH_Video_QB
     */
    class Video extends Model {}
    
    /**
     * @property int $id
     * @property string $code
     * @property int $value
     * @property string $type
     * @property string $application
     * @property int|null $application_id
     * @property string|null $description
     * @property bool $is_active
     * @property int|null $max_usages
     * @property int|null $remaining_usages
     * @property Carbon|null $expires_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product|null $applicationItem
     * @method BelongsTo|_IH_Product_QB applicationItem()
     * @property _IH_Order_C|Order[] $orders
     * @property-read int $orders_count
     * @method HasMany|_IH_Order_QB orders()
     * @method static _IH_Voucher_QB onWriteConnection()
     * @method _IH_Voucher_QB newQuery()
     * @method static _IH_Voucher_QB on(null|string $connection = null)
     * @method static _IH_Voucher_QB query()
     * @method static _IH_Voucher_QB with(array|string $relations)
     * @method _IH_Voucher_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Voucher_C|Voucher[] all()
     * @foreignLinks id,\App\Model\Order,voucher_id
     * @mixin _IH_Voucher_QB
     */
    class Voucher extends Model {}
}