<?php //fdcd70b3c3cea6dc20fea2197198667b
/** @noinspection all */

namespace App\Model\Article {

    use App\Model\Article;
    use App\Model\Attribute;
    use App\Model\Category;
    use App\Model\Category\CategoryAttribute;
    use App\Model\Product;
    use App\Model\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleArchive_C;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleArchive_QB;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleCategory_C;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleCategory_QB;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleComment_C;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticleComment_QB;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticlePhoto_C;
    use LaravelIdea\Helper\App\Model\Article\_IH_ArticlePhoto_QB;
    use LaravelIdea\Helper\App\Model\Category\_IH_CategoryAttribute_C;
    use LaravelIdea\Helper\App\Model\Category\_IH_CategoryAttribute_QB;
    use LaravelIdea\Helper\App\Model\_IH_Article_C;
    use LaravelIdea\Helper\App\Model\_IH_Article_QB;
    use LaravelIdea\Helper\App\Model\_IH_Attribute_C;
    use LaravelIdea\Helper\App\Model\_IH_Attribute_QB;
    use LaravelIdea\Helper\App\Model\_IH_Category_C;
    use LaravelIdea\Helper\App\Model\_IH_Category_QB;
    use LaravelIdea\Helper\App\Model\_IH_Product_C;
    use LaravelIdea\Helper\App\Model\_IH_Product_QB;
    use LaravelIdea\Helper\App\Model\_IH_User_QB;
    
    /**
     * @property int $id
     * @property int $year
     * @property int $month
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ArticleArchive_QB onWriteConnection()
     * @method _IH_ArticleArchive_QB newQuery()
     * @method static _IH_ArticleArchive_QB on(null|string $connection = null)
     * @method static _IH_ArticleArchive_QB query()
     * @method static _IH_ArticleArchive_QB with(array|string $relations)
     * @method _IH_ArticleArchive_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ArticleArchive_C|ArticleArchive[] all()
     * @mixin _IH_ArticleArchive_QB
     */
    class ArticleArchive extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string $slug
     * @property int $priority
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $body attribute
     * @property-read $description attribute
     * @property-read $first_product attribute
     * @property-read $path attribute
     * @property-read $title attribute
     * @property-read $url attribute
     * @property-read $value attribute
     * @property _IH_Article_C|Article[] $activeArticles
     * @property-read int $active_articles_count
     * @method HasMany|_IH_Article_QB activeArticles()
     * @property _IH_Article_C|Article[] $articles
     * @property-read int $articles_count
     * @method HasMany|_IH_Article_QB articles()
     * @property _IH_CategoryAttribute_C|CategoryAttribute[] $attributes
     * @property-read int $attributes_count
     * @method HasMany|_IH_CategoryAttribute_QB attributes()
     * @property _IH_Attribute_C|Attribute[] $attributesPivot
     * @property-read int $attributes_pivot_count
     * @method BelongsToMany|_IH_Attribute_QB attributesPivot()
     * @property _IH_Category_C|Category[] $children
     * @property-read int $children_count
     * @method HasMany|_IH_Category_QB children()
     * @property _IH_CategoryAttribute_C|CategoryAttribute[] $filters
     * @property-read int $filters_count
     * @method HasMany|_IH_CategoryAttribute_QB filters()
     * @property Category $parentCat
     * @method BelongsTo|_IH_Category_QB parentCat()
     * @property _IH_Product_C|Product[] $product
     * @property-read int $product_count
     * @method BelongsToMany|_IH_Product_QB product()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method BelongsToMany|_IH_Product_QB products()
     * @property _IH_Product_C|Product[] $products_active
     * @property-read int $products_active_count
     * @method BelongsToMany|_IH_Product_QB products_active()
     * @property _IH_Product_C|Product[] $tiedActiveProducts
     * @property-read int $tied_active_products_count
     * @method HasMany|_IH_Product_QB tiedActiveProducts()
     * @property _IH_Product_C|Product[] $tiedProducts
     * @property-read int $tied_products_count
     * @method HasMany|_IH_Product_QB tiedProducts()
     * @method static _IH_ArticleCategory_QB onWriteConnection()
     * @method _IH_ArticleCategory_QB newQuery()
     * @method static _IH_ArticleCategory_QB on(null|string $connection = null)
     * @method static _IH_ArticleCategory_QB query()
     * @method static _IH_ArticleCategory_QB with(array|string $relations)
     * @method _IH_ArticleCategory_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ArticleCategory_C|ArticleCategory[] all()
     * @mixin _IH_ArticleCategory_QB
     */
    class ArticleCategory extends Model {}
    
    /**
     * @property Article $article
     * @method BelongsTo|_IH_Article_QB article()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ArticleComment_QB onWriteConnection()
     * @method _IH_ArticleComment_QB newQuery()
     * @method static _IH_ArticleComment_QB on(null|string $connection = null)
     * @method static _IH_ArticleComment_QB query()
     * @method static _IH_ArticleComment_QB with(array|string $relations)
     * @method _IH_ArticleComment_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ArticleComment_C|ArticleComment[] all()
     * @mixin _IH_ArticleComment_QB
     */
    class ArticleComment extends Model {}
    
    /**
     * @property int $id
     * @property int $article_id
     * @property string $filename
     * @property int $priority
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Article $item
     * @method BelongsTo|_IH_Article_QB item()
     * @method static _IH_ArticlePhoto_QB onWriteConnection()
     * @method _IH_ArticlePhoto_QB newQuery()
     * @method static _IH_ArticlePhoto_QB on(null|string $connection = null)
     * @method static _IH_ArticlePhoto_QB query()
     * @method static _IH_ArticlePhoto_QB with(array|string $relations)
     * @method _IH_ArticlePhoto_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ArticlePhoto_C|ArticlePhoto[] all()
     * @ownLinks article_id,\App\Model\Article,id
     * @mixin _IH_ArticlePhoto_QB
     */
    class ArticlePhoto extends Model {}
}