<?php //f711b849bbb33423cd2ed929f3ace231
/** @noinspection all */

namespace App\Model\Order {

    use App\Model\Order;
    use App\Model\Product;
    use App\Model\Vendor;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Model\Order\_IH_OrderProduct_C;
    use LaravelIdea\Helper\App\Model\Order\_IH_OrderProduct_QB;
    use LaravelIdea\Helper\App\Model\Order\_IH_OrderVendor_C;
    use LaravelIdea\Helper\App\Model\Order\_IH_OrderVendor_QB;
    use LaravelIdea\Helper\App\Model\_IH_Order_QB;
    use LaravelIdea\Helper\App\Model\_IH_Product_QB;
    use LaravelIdea\Helper\App\Model\_IH_Vendor_QB;
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int $product_id
     * @property int $offer_id
     * @property int $vendor_id
     * @property string $name
     * @property float $price
     * @property int $qty
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Order $order
     * @method BelongsTo|_IH_Order_QB order()
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_OrderProduct_QB onWriteConnection()
     * @method _IH_OrderProduct_QB newQuery()
     * @method static _IH_OrderProduct_QB on(null|string $connection = null)
     * @method static _IH_OrderProduct_QB query()
     * @method static _IH_OrderProduct_QB with(array|string $relations)
     * @method _IH_OrderProduct_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderProduct_C|OrderProduct[] all()
     * @ownLinks order_id,\App\Model\Order,id|product_id,\App\Model\Product,id
     * @mixin _IH_OrderProduct_QB
     */
    class OrderProduct extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int $vendor_id
     * @property float $price
     * @property float $fee
     * @property float $price_delivery
     * @property string|null $vendor_invoice_filename
     * @property string|null $admin_invoice_filename
     * @property string $status
     * @property string|null $awb
     * @property string|null $delivery_company
     * @property bool $delivery_mail_sent
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $status_class attribute
     * @property-read $status_detail attribute
     * @property Order $order
     * @method BelongsTo|_IH_Order_QB order()
     * @property _IH_OrderProduct_C|OrderProduct[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_OrderProduct_QB products()
     * @property Vendor $vendor
     * @method BelongsTo|_IH_Vendor_QB vendor()
     * @method static _IH_OrderVendor_QB onWriteConnection()
     * @method _IH_OrderVendor_QB newQuery()
     * @method static _IH_OrderVendor_QB on(null|string $connection = null)
     * @method static _IH_OrderVendor_QB query()
     * @method static _IH_OrderVendor_QB with(array|string $relations)
     * @method _IH_OrderVendor_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderVendor_C|OrderVendor[] all()
     * @ownLinks order_id,\App\Model\Order,id
     * @mixin _IH_OrderVendor_QB
     */
    class OrderVendor extends Model {}
}